
#ifndef _REG_PARAMETER_H_
#define _REG_PARAMETER_H_

//-----------------------------------------------------------------
#include "mcu.h"

//-----------------------------------------------------------------
#define	BC7262SCL		_pb6
#define	BC7262SCLDIR	_pbc6
#define BC7262SCLPU		_pbpu6

#define	BC7262SDA		_pa3
#define	BC7262SDADIR	_pac3
#define	BC7262SDAPU		_papu3

#define	BC7262STS		_pa1
#define	BC7262STSDIR	_pac1
#define	BC7262STSPU		_papu1
/*#define	BC7262STSWU		_pawu1*/

//-----------------------------------------------------------------
#define WOT_TU                  0		// 0:  10 ms   CFG11 [2] WOT time unit.  0:10mS, 1:625uS
										// 1: 625 us   CFG11 [2] WOT time unit.  0:10mS, 1:625uS										
#define	XTAL_CLOAD				0x10	// 16pF, Trim value for the internal capacitor load for the crystal

#define	TPCAC_EN				0		// 0/1GTP calibration auto calibration enables

#define	TX_PWR					P07DBM

#define RNDDLY_WHTSEED_NONZERO  0x23	// HW utilize whitening for random advDelay, thus whitening_seed cannot be zero

#define	RNDDLY_WHTSEED			(0x00+RNDDLY_WHTSEED_NONZERO)	//b7=Whitening seed select

#define	PKT_AUTORS			    10		//Packet auto resend times. 
										//00h: 1 time, not resend, FFh: always resend until L2TX_START = 0

#define	PKT_APRD				0		//Auto period re-transmit delay time.
										//Set up default to 8ms, and the range is 250us(00h) ~ 8ms(1Fh).

#define	APRD_PDTH				0		//APRD power down threshold.
										//0h: 1ms, 1h: 1.5ms, 2h: 2ms, 3h: 3ms

//Transmit period. Default is 1s.
//Period = 0.625 / 10ms *(1+PKT_PERIODS), 10ms(000h) ~ 10240ms(3FFh)
#if	(WOT_TU==1)	//WOT unit=0.625ms =>0.625~640ms
  #define	PKT_PERIODS			10	 										
  #define	ADVE_PERIOD_TIMER		((PKT_PERIODS+1)*625/1000)	//Adev Event period timer 10ms~10240ms
#else	//WOT unit=10ms    => 10~1024ms
  #define	PKT_PERIODS		    0			 
  #define	ADVE_PERIOD_TIMER	((PKT_PERIODS+1)*10)	//Adev Event period timer 10ms~10240ms
#endif
										

#define RNDDLY_EN               0		//0=disable random advDelay  CFG07 [5]RNDDLY_EN
                                       	//1=enable random advDelay  CFG07 [5]RNDDLY_EN

#define	PMLEN					ONE_BYTE_PRM		//Preamble length: 0h: 1 byte, 1h: 2 bytes
#define	WHT_EN					1			//have to enable for BLE Broadcast
#define WHT_ADDR_TYPE			PUB_ADDR	//RAND_ADDR

#define	HOP_FNO				    7			//b[2:0] Hopping frequency number

#define	AGC_EN					0x01		
#define ACFO_EN					0x01		

#define	GIO1_S					INPUT_MODE
#define	GIO2_S					L2TRX_START

#define	GIOPU					0x1F
#define	SCLPU					1
#define SDAPU					1

#define I2CAG_EN				0	//I2C anti-glitch disables 
#if (_I2C_PULLUP_==1)
#define I2COD_EN				1	//I2C open drain enables
#else
#define I2COD_EN				0	//I2C open drain disables
#endif
#define CRWFF_EN				1	//Continuous Read and Write FIFO enable by I2C interface				
#define IRQCLR					0	//Layer 2 IRQ auto clear after read IRQ setting, 0h: Disable 1h: Enable  
#define	IRQACT					0	//Layer 2 IRQ active setting, 0h: low active, 1h: high active

#define TIMEOUT_COUNTER			((((ADVE_PERIOD_TIMER*PKT_AUTORS)+5)*105+199)/200)

#if	TIMEOUT_COUNTER > 65536
	Error 'TIMER_COUNTER'
#endif	




#endif   /* _REG_PARAMETER_H_ */